#include "MacAddress.h" 
#include  <comutil.h>  
#include  <Wbemidl.h> 
#include  <tchar.h>
#include <winioctl.h>
#include  <strsafe.h> 
#include  <algorithm>  
#include  <ntddndis.h>  
#include  <atlconv.h>

#include <iostream> 
using namespace std; 
#include <comdef.h> 
#include <Wbemidl.h> 
#include <vector>
#include <string>

#include <setupapi.h>
#include <devguid.h>
#include <regstr.h>
#pragma comment(lib,"Setupapi.lib")

const GUID GUID_Net = {0x4D36E972,0xE325,0x11CE, {0xBF,0xC1,0x08,0x00,0x2B,0xE1,0x03,0x18}};

//#pragma comment (lib, "comsuppw.lib")  
//#pragma comment (lib, "wbemuuid.lib")
//#pragma comment (lib, "ole32.lib")

using namespace std;

typedef struct _T_WQL_QUERY{
	const CHAR*	szSelect;		// SELECT语句
	const WCHAR*	szProperty;// 属性字段  
} T_WQL_QUERY; 

const T_WQL_QUERY szWQLQuery[] = {
	// 包含USB网卡  	
	"SELECT * FROM Win32_NetworkAdapter WHERE (MACAddress IS NOT NULL) AND (NOT (PNPDeviceID LIKE 'ROOT%'))",  
	L"PNPDeviceID",
	// 不包含USB网卡
	"SELECT * FROM Win32_NetworkAdapter WHERE (MACAddress IS NOT NULL) AND (NOT (PNPDeviceID LIKE 'ROOT%')) AND (NOT (PNPDeviceID LIKE 'USB%'))",
	L"PNPDeviceID"}; 

BYTE  MyMacAddress::PermanentAddress[MACADDRESS_BYTELEN];
BYTE MyMacAddress::MACAddress[MACADDRESS_BYTELEN];

char  szTemp[6] = {0};

MyMacAddress::MyMacAddress(void)
{
	//ZeroMemory(PermanentAddress, sizeof(PermanentAddress));
	//ZeroMemory(MACAddress, sizeof(MACAddress));
}

MyMacAddress::~MyMacAddress(void)
{
}
void MyMacAddress::MacCoUninitialize(HRESULT hres)
{
	if( S_OK == hres || S_FALSE == hres)
		CoUninitialize();
}
void MyMacAddress::GetMacReallyValue(BYTE MacAddress[MACADDRESS_BYTELEN], char szRealMacAddr[MACADDRESS_CHARSLEN])
{
	ZeroMemory(szRealMacAddr, MACADDRESS_CHARSLEN * sizeof(char));
	sprintf(szRealMacAddr, "%02x-%02x-%02x-%02x-%02x-%02x", MacAddress[0], MacAddress[1], MacAddress[2], MacAddress[3], MacAddress[4], MacAddress[5]);
}
/*
int MyMacAddress::WMI_GetMacAddress(int iQueryType, int iSize)
{
	ZeroMemory(PermanentAddress, sizeof(PermanentAddress));
	ZeroMemory(MACAddress, sizeof(MACAddress));
	HRESULT hres;  	
	int	iTotal = 0;
	
	if( (iQueryType  < 0) || (iQueryType >= sizeof(szWQLQuery)/sizeof(T_WQL_QUERY)) ) 
	{  		
		return -1;
	}    	
// 	hres = CoInitializeEx( NULL, COINIT_MULTITHREADED); 
// 	if( FAILED(hres) )      
// 	{          
// 		return -2; 
// 	}        
	HRESULT hCoRes = CoInitializeEx( NULL, COINIT_MULTITHREADED); 
	if( FAILED(hCoRes) && RPC_E_CHANGED_MODE != hCoRes)
	{          
		return -2;
	} 
// 	hres = CoInitializeSecurity(NULL, -1, NULL, NULL, RPC_C_AUTHN_LEVEL_DEFAULT, RPC_C_IMP_LEVEL_IMPERSONATE, NULL, EOAC_NONE, NULL);
// 	if( FAILED(hres) )
// 	{          
// 		CoUninitialize();
// 		return -2;      
// 	}        	
	IWbemLocator *pLoc = NULL;
	hres = CoCreateInstance(CLSID_WbemLocator, NULL, CLSCTX_INPROC_SERVER, IID_IWbemLocator, reinterpret_cast <LPVOID*>(&pLoc));
	if( FAILED(hres) || !pLoc )
	{  		
		MacCoUninitialize(hCoRes);
		return -2;      
	}
	IWbemServices *pSvc = NULL;
	hres = pLoc->ConnectServer(_bstr_t( L"ROOT\\CIMV2" ), NULL, NULL, NULL, 0, NULL, NULL, &pSvc);
	if( FAILED(hres) || !pSvc )      
	{  		
		pLoc->Release();           
		MacCoUninitialize(hCoRes);          
		return -2;      
	}    	
	// 设置请求代理的安全级别
	hres = CoSetProxyBlanket(pSvc, RPC_C_AUTHN_WINNT, RPC_C_AUTHZ_NONE, NULL, RPC_C_AUTHN_LEVEL_CALL, RPC_C_IMP_LEVEL_IMPERSONATE, NULL, EOAC_NONE);
	if( FAILED(hres) )
	{          
		pSvc->Release();
		pLoc->Release(); 
		MacCoUninitialize(hCoRes);  
		return -2;      
	}       
	IEnumWbemClassObject *pEnumerator = NULL;
	hres = pSvc->ExecQuery(bstr_t("WQL"), bstr_t( szWQLQuery[iQueryType].szSelect), WBEM_FLAG_FORWARD_ONLY | WBEM_FLAG_RETURN_IMMEDIATELY, NULL, &pEnumerator);  	
	if( FAILED(hres) ) 
	{          
		pSvc->Release();
		pLoc->Release();  
		MacCoUninitialize(hCoRes);         
		return -3;      
	}

	BYTE byTemp[6] = {'\0'};
	iTotal = 0;
	while( pEnumerator )
	{  		
		IWbemClassObject *pclsObj = NULL;
		ULONG uReturn = 0;    	
// 		if(iTotal >= iSize)   //只是枚举了一个网卡
// 		{  			
// 			break;  	
// 		}
		pEnumerator->Next( WBEM_INFINITE, 1, &pclsObj, &uReturn );            
		if( uReturn == 0 )         
		{              
			break;
		}
		VARIANT	vtProperty;  	
		TCHAR szProperty[128]; 
		// 获取网卡范例ID		
		VariantInit( &vtProperty );	  	
		pclsObj->Get( szWQLQuery[iQueryType].szProperty, 0, &vtProperty, NULL, NULL );  
		StringCchCopy( szProperty, sizeof(szProperty)/sizeof(TCHAR), W2T(vtProperty.bstrVal) );  
		VariantClear( &vtProperty );
#if defined(_DEBUG)
		printf( "%S\n",szProperty );
#endif

		//{1A3E09BE-1E45-494B-9174-D7385B45BBF5} nv软网卡标识 现在nv不在生产此类型的主板
		bool bRes = ( _wcsnicmp( szProperty, L"PCI", 3 )==0 || _wcsnicmp( szProperty, L"{1A3E09BE-1E45-494B-9174-D7385B45BBF5}", wcslen( L"{1A3E09BE-1E45-494B-9174-D7385B45BBF5}" ) )==0 );
		if( bRes && GetPNPDeviceID( szProperty) )  	
		{  	
			//printf("%S\n",szProperty);
			//多网卡情况 选择最小的mac
			if( iTotal == 0 || (iTotal>0 && memcmp( byTemp,szTemp, 6 )>0) )
			{
				memcpy( byTemp, szTemp, 6 );
			}
			iTotal++;
		}  		  		
		pclsObj->Release();  
	}
	// 释放资源  
	pEnumerator->Release(); 
	pSvc->Release();     
	pLoc->Release();   
	MacCoUninitialize(hCoRes);   

	memcpy( PermanentAddress, byTemp, 6 );
	
	return iTotal;  
}
*/
int MyMacAddress::WMI_GetMacAddress(int iQueryType, int iSize)
{
	HDEVINFO hDevInfo;
	SP_DEVINFO_DATA DeviceInfoData;
	TCHAR szProperty[128];
	BYTE byTemp[6] = {'\0'};
	DWORD dwCount;
	int iTotal = 0;

	ZeroMemory(PermanentAddress, sizeof(PermanentAddress));
	ZeroMemory(MACAddress, sizeof(MACAddress));

	hDevInfo = SetupDiGetClassDevs(	&GUID_Net, 0, 0, DIGCF_PRESENT );
	if (hDevInfo == INVALID_HANDLE_VALUE)
		return -1;

	DeviceInfoData.cbSize = sizeof(SP_DEVINFO_DATA);
    for( dwCount=0; SetupDiEnumDeviceInfo( hDevInfo, dwCount, &DeviceInfoData); dwCount++ )
	{  		
		if (!SetupDiGetDeviceInstanceId( hDevInfo, &DeviceInfoData, szProperty, sizeof(szProperty), NULL))
			break;

		//{1A3E09BE-1E45-494B-9174-D7385B45BBF5} nv软网卡标识 现在nv不在生产此类型的主板
		bool bRes = ( _wcsnicmp( szProperty, L"PCI", 3 )==0 || _wcsnicmp( szProperty, L"{1A3E09BE-1E45-494B-9174-D7385B45BBF5}", wcslen( L"{1A3E09BE-1E45-494B-9174-D7385B45BBF5}" ) )==0 );
		if( bRes && GetPNPDeviceID( szProperty) )  	
		{  	
			//多网卡情况 选择最小的mac
			if( iTotal == 0 || (iTotal>0 && memcmp( byTemp,szTemp, 6 )>0) )
			{
				memcpy( byTemp, szTemp, 6 );
			}
			iTotal++;
		}  		  		
	}
	// 释放资源  
	SetupDiDestroyDeviceInfoList( hDevInfo ); 

	memcpy( PermanentAddress, byTemp, 6 );
	
	return iTotal;  
}

BOOL MyMacAddress::GetPNPDeviceID( const TCHAR *PNPDeviceID)
 {  	
	// GUID_NDIS_LAN_CLASS   ad498944-762f-11d0-8dcb-00c04fc3358c
	 TCHAR	DevicePath[MAX_PATH];
	 HANDLE	hDeviceFile;
	 BOOL	isOK = FALSE;    // 生成设备路径名
//	 char szbuf[100];
//	 memset(szbuf,0,100);
//	 DWORD  num =0 ;
	 memset( szTemp, 0, 6 );
	 ZeroMemory(DevicePath, sizeof(DevicePath));
	 StringCchCopy( DevicePath, MAX_PATH, TEXT("\\\\.\\"));
	 StringCchCat( DevicePath, MAX_PATH, PNPDeviceID );
	 StringCchCat( DevicePath, MAX_PATH, TEXT("#{ad498944-762f-11d0-8dcb-00c04fc3358c}") );
	 std::replace( DevicePath + 4, DevicePath + 4 + _tcslen(PNPDeviceID), TEXT('\\'), TEXT('#') );     	// 获取设备句柄
	 hDeviceFile = CreateFile( DevicePath, 0, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);
	 if( hDeviceFile != INVALID_HANDLE_VALUE )
	 {
		 ULONG	dwID;
		 BYTE	ucData[8];
		 DWORD	dwByteRet = 0;
		 dwID = OID_802_3_CURRENT_ADDRESS;
		 isOK = DeviceIoControl( hDeviceFile, IOCTL_NDIS_QUERY_GLOBAL_STATS, &dwID, sizeof(dwID), ucData, sizeof(ucData), &dwByteRet, NULL );
		 if( isOK )
		 {
			 if( dwByteRet > 6 )//加入长度判断
				 dwByteRet = 6;
			 memcpy( MACAddress, ucData, dwByteRet );
		 }

		 dwByteRet = 0;
		 dwID = OID_802_3_PERMANENT_ADDRESS;  			
		 isOK = DeviceIoControl( hDeviceFile, IOCTL_NDIS_QUERY_GLOBAL_STATS, &dwID, sizeof(dwID), ucData, sizeof(ucData), &dwByteRet, NULL );
		 if( isOK )
		 {	
			 dwID = OID_GEN_VENDOR_DESCRIPTION;	
			// isOK = DeviceIoControl( hDeviceFile, IOCTL_NDIS_QUERY_GLOBAL_STATS, &dwID, sizeof(dwID), szbuf, 100, &num, NULL );
			 if( isOK )
			 {
			//	 printf("%s\n",szbuf);
				 
				 if( dwByteRet > 6 )//加入长度判断
					 dwByteRet = 6;
				 memcpy( PermanentAddress, ucData, dwByteRet );               
				 memcpy( szTemp, ucData, dwByteRet );
					 //printf("%S\n",PNPDeviceID);
					// printf("%02x-%02x-%02x-%02x-%02x-%02x\n",szTemp[0],szTemp[1],szTemp[2],szTemp[3],szTemp[4],szTemp[5]);
					/* printf("%02x-%02x-%02x-%02x-%02x-%02x\n",
						 MyMacAddress::PermanentAddress[0],MyMacAddress::PermanentAddress[1],
						 MyMacAddress::PermanentAddress[2],MyMacAddress::PermanentAddress[3],
						 MyMacAddress::PermanentAddress[4],MyMacAddress::PermanentAddress[5]);
					 printf(".......................................\n");*/
				 
			 }
		 }  	
		 CloseHandle( hDeviceFile );  	
	 }    	
	 return isOK;  
 }
