#pragma once
#include <windows.h>

#pragma warning(disable : 4996)
enum OSID 
{
	WIN_UNKNOWN = 0,
	WIN9X_ME	= 1,//0x0002
	WIN2000		= 2,//0x0004
	WINXP_X86	= 4,//0x0008
	WINXP_X64	= 8,//0x0010
	WIN2003_X86 = 16,//0x0020
	WIN2003_X64 = 32,//0x0040
	VISTA_X86	= 64,//0x0080
	VISTA_X64	= 128,//0x0100
	WIN2008_X86 = 256,//0x0200
	WIN2008_X64 = 512,//0x0400
	WIN7_X86    = 1024,
	WIN7_X64    = 2048,
	WIN8_X86	= 4096,
	WIN8_X64	= 8192
};
__inline unsigned short Global_GetLangType()
{
	WORD uLangID;
	uLangID = GetUserDefaultLangID();
	switch( uLangID &0x000f )
	{
	case 4:
		uLangID = 0x0804;
		break;
	case 9:
		uLangID = 0x0009;
		break;
	default:
		uLangID = 0x0804;
		break;
	}
	return uLangID;
}

typedef BOOL (WINAPI *LPFN_ISWOW64PROCESS) (HANDLE, PBOOL);
__inline unsigned short Global_GetOSType()
{

	static unsigned short cOSType = 0;
	unsigned short wordLen = 32;
	if ( cOSType != 0) //Ѿ ȡ
	{
		return cOSType;
	}
	cOSType = WIN_UNKNOWN;
	if( sizeof(void*) == 4 )
	{
		LPFN_ISWOW64PROCESS fnIsWow64Process;
		BOOL bIsWow64;
		fnIsWow64Process = (LPFN_ISWOW64PROCESS)GetProcAddress( GetModuleHandleA("kernel32"), "IsWow64Process" );
		if ( fnIsWow64Process != NULL )
		{
			if ( fnIsWow64Process( GetCurrentProcess(), &bIsWow64 ) )
			{
				if ( bIsWow64 )
				{
					wordLen = 64;
				}
			}
		}
	}
	else
	{
		wordLen = 64;
	}

	OSVERSIONINFOEX osVerInfo;
	DWORD osMajorVer, osMinorVer;
	ZeroMemory((void *)&osVerInfo, sizeof(OSVERSIONINFOEX));
	osVerInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);
	if( GetVersionEx( (OSVERSIONINFO*)&osVerInfo ) == 0)
	{
		return cOSType;
	}
	osMajorVer = osVerInfo.dwMajorVersion;
	osMinorVer = osVerInfo.dwMinorVersion;

	if( osMajorVer == 4 )
	{
		// 95, 98, ME
		if ( osMinorVer == 0 || osMinorVer == 10 || osMinorVer == 90 ) 
		{
			cOSType = WIN9X_ME;
		}
	}
	else if ( osMajorVer == 5 )
	{
		if ( osMinorVer == 0 )
		{
			cOSType = WIN2000;
		}
		else if ( osMinorVer == 1 )
		{
			if ( wordLen == 32 )
			{
				cOSType = WINXP_X86;
			}
			else if ( wordLen == 64 )
			{
				cOSType = WINXP_X64;
			}
		}
		else if ( osMinorVer == 2 )
		{
			if ( wordLen == 32 )
			{
				cOSType = WIN2003_X86;
			}
			else if ( wordLen == 64 )
			{
				cOSType = WIN2003_X64;
			}
		}
	}
	else if ( osMajorVer == 6 && osMinorVer == 0 )
	{
		if ( osVerInfo.wProductType == VER_NT_SERVER )
		{
			if( wordLen == 32 )
			{
				cOSType = WIN2008_X86;
			}
			else if ( wordLen == 64 )
			{
				cOSType = WIN2008_X64;
			}
		}
		else
		{
			if( wordLen == 32 )
			{
				cOSType = VISTA_X86;
			}
			else if ( wordLen == 64 )
			{
				cOSType = VISTA_X64;
			}

		}
	}
	else if (osMajorVer == 6 && osMinorVer == 1)
	{
		if (wordLen == 32)
		{
			cOSType = WIN7_X86;
		}
		else if (wordLen == 64)
		{
			cOSType = WIN7_X64;
		}
	}
	else if( osMajorVer >= 6 )
	{
		cOSType = ((wordLen==64)?WIN8_X64:WIN8_X86);
	}
	return cOSType;
}